<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->string('name', 255);
			$table->text('description');
			$table->enum('status', array('active', 'completed', 'pending', 'ready', 'onhold'));
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}