<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('panels', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stiffeners', function(Blueprint $table) {
			$table->foreign('panel_id')->references('id')->on('panels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bends', function(Blueprint $table) {
			$table->foreign('panel_id')->references('id')->on('panels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('visualizations', function(Blueprint $table) {
			$table->foreign('panel_id')->references('id')->on('panels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('approval_workflows', function(Blueprint $table) {
			$table->foreign('approver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('approval_workflows', function(Blueprint $table) {
			$table->foreign('panel_id')->references('id')->on('panels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_user_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_project_id_foreign');
		});
		Schema::table('panels', function(Blueprint $table) {
			$table->dropForeign('panels_project_id_foreign');
		});
		Schema::table('stiffeners', function(Blueprint $table) {
			$table->dropForeign('stiffeners_panel_id_foreign');
		});
		Schema::table('bends', function(Blueprint $table) {
			$table->dropForeign('bends_panel_id_foreign');
		});
		Schema::table('visualizations', function(Blueprint $table) {
			$table->dropForeign('visualizations_panel_id_foreign');
		});
		Schema::table('approval_workflows', function(Blueprint $table) {
			$table->dropForeign('approval_workflows_approver_id_foreign');
		});
		Schema::table('approval_workflows', function(Blueprint $table) {
			$table->dropForeign('approval_workflows_panel_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_user_id_foreign');
		});
	}
}