<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Stiffener extends Eloquent {

	protected $table = 'stiffeners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('dimensions', 'material_type', 'stiffener_type', 'panel_id');

	public function panel()
	{
		return $this->belongsTo('App\Models\Panel');
	}

}