<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceCostsTable extends Migration {

	public function up()
	{
		Schema::create('service_costs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigIncrements('service_id');
			$table->enum('type', array('hour', 'km', 'city'));
			$table->double('start_price');
			$table->double('end_price')->nullable();
			$table->integer('count');
		});
	}

	public function down()
	{
		Schema::drop('service_costs');
	}
}