<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('influencer_id')->unsigned();
			$table->integer('campaign_id')->unsigned();
			$table->text('content');
			$table->string('image_content_url')->nullable();
			$table->integer('likes');
			$table->integer('shares');
			$table->string('favorites');
			$table->string('status');
			$table->integer('comments');
			$table->integer('social_media_type_id')->unsigned();
			$table->timestamp('time_post');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}