<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Advertiser extends Eloquent {

	protected $table = 'advertisers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function postCategories()
	{
		return $this->hasMany('\App\Model\Category');
	}

	public function campaigns()
	{
		return $this->hasMany('\App\Model\Campaign');
	}

}