<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function advertiser()
	{
		return $this->hasOne('\App\Model\Advertiser');
	}

	public function influencer()
	{
		return $this->hasOne('\App\Model\Influencer');
	}

	public function escrowHistory()
	{
		return $this->hasMany('\App\Model\EscrowHistory');
	}

	public function bankAccounts()
	{
		return $this->hasMany('\App\Model\BankAccounts');
	}

}