<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->foreign('next_question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_question_id_foreign');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->dropForeign('choices_question_id_foreign');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->dropForeign('choices_next_question_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_quiz_id_foreign');
		});
	}
}