<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Products extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('name_ar', 'name_en', 'descr_ar', 'descr_en', 'min_orders', 'price', 'discount_price', 'qty', 'category_id', 'supplier_id', 'commerical_guarantee', 'quality_pro', 'shipping_specific_date', 'unit_pro', 'ready_ship', 'sale_end', 'like_pro');

    public function getCategory()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function image()
    {
        return $this->morphMany('Images');
    }

    public function getFavs()
    {
        return $this->morphMany('Favourites', 'getFav');
    }

    public function getRatings()
    {
        return $this->morphMany('Ratings', 'getRate');
    }

    public function getStores()
    {
        return $this->belongsTo('Suppliers', 'store_id');
    }

    public function getProductAttribute()
    {
        return $this->hasMany('ProductAttribute');
    }

    public function getCarts()
    {
        return $this->hasMany('Cart');
    }

    public function getSliders()
    {
        return $this->morphMany('Slider', 'getSliderable');
    }

}