<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 255);
			$table->string('name_en', 255);
			$table->string('descr_ar', 255);
			$table->string('descr_en', 255);
			$table->string('min_orders');
			$table->double('price');
			$table->string('discount_price')->nullable();
			$table->integer('qty');
			$table->integer('category_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->integer('commerical_guarantee');
			$table->integer('quality_pro');
			$table->integer('shipping_specific_date');
			$table->string('unit_pro');
			$table->integer('ready_ship');
			$table->date('sale_end');
			$table->integer('like_pro');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}