<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('promotion_sup_id')->references('id')->on('promotion_supplier')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('town_id')->references('id')->on('towns')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('town_id')->references('id')->on('towns')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('marterial_pro_attr_id')->references('id')->on('product_attribute')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('bank_account_id')->references('id')->on('bank_accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('users_addresses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('users_addresses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('material_pro_attr_id')->references('id')->on('product_attribute')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('users_addresses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('order_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payment_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('towns', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('device_tokens_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_properties', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('supp_certificates', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('supp_certificates', function(Blueprint $table) {
			$table->foreign('certificate_id')->references('id')->on('certificates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_card', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_card', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_coupon', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_coupon', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('result_search', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers_properties', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_promotion_sup_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_category_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_country_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_city_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_town_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_user_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_supplier_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_supplier_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_country_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_city_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_town_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_product_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_marterial_pro_attr_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_user_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_bank_account_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_coupon_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_payment_type_id_foreign');
		});
		Schema::table('payment_details', function(Blueprint $table) {
			$table->dropForeign('payment_details_address_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_user_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_product_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_order_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_product_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_material_pro_attr_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_address_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_supplier_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_status_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_coupon_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_id_foreign');
		});
		Schema::table('towns', function(Blueprint $table) {
			$table->dropForeign('towns_city_id_foreign');
		});
		Schema::table('device_tokens_users', function(Blueprint $table) {
			$table->dropForeign('device_tokens_users_user_id_foreign');
		});
		Schema::table('product_properties', function(Blueprint $table) {
			$table->dropForeign('product_properties_product_id_foreign');
		});
		Schema::table('supp_certificates', function(Blueprint $table) {
			$table->dropForeign('supp_certificates_supplier_id_foreign');
		});
		Schema::table('supp_certificates', function(Blueprint $table) {
			$table->dropForeign('supp_certificates_certificate_id_foreign');
		});
		Schema::table('payment_card', function(Blueprint $table) {
			$table->dropForeign('payment_card_user_id_foreign');
		});
		Schema::table('payment_card', function(Blueprint $table) {
			$table->dropForeign('payment_card_payment_type_id_foreign');
		});
		Schema::table('users_coupon', function(Blueprint $table) {
			$table->dropForeign('users_coupon_coupon_id_foreign');
		});
		Schema::table('users_coupon', function(Blueprint $table) {
			$table->dropForeign('users_coupon_user_id_foreign');
		});
		Schema::table('result_search', function(Blueprint $table) {
			$table->dropForeign('result_search_user_id_foreign');
		});
		Schema::table('suppliers_properties', function(Blueprint $table) {
			$table->dropForeign('suppliers_properties_supplier_id_foreign');
		});
	}
}