<?php

namespace App;

class Cart extends Eloquent {

	protected $table = 'cart';
	public $timestamps = true;
	protected $fillable = array('qty', 'price', 'product_id', 'user_id', 'marterial_pro_attr_id');

	public function getUser()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function getProduct()
	{
		return $this->belongsTo('Products', 'product_id');
	}

	public function getColor()
	{
		return $this->belongsTo('ProductAttribute', 'color_id');
	}

	public function getSize()
	{
		return $this->belongsTo('ProductAttribute', 'size_id');
	}

}