<?php

namespace App;

class Suppliers extends Eloquent {

	protected $table = 'suppliers';
	public $timestamps = true;
	protected $fillable = array('id', 'name_ar_company', 'name_en_company', 'type_work', 'created_year', 'num_employees', 'place_company', 'descr_ar', 'descr_en', 'commerical_guarantee', 'quality_sup', 'shipping_specific_date', 'promotion_sup_id', 'job_title', 'phone', 'tel', 'fax', 'address', 'postal_code', 'approve', 'category_id', 'country_id', 'city_id', 'town_id', 'user_id');

	public function getUser()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function image()
	{
		return $this->morphOne('Images');
	}

	public function getCategory()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function getFav()
	{
		return $this->morphMany('Favourites');
	}

	public function getRatings()
	{
		return $this->morphMany('Ratings', 'getRate');
	}

	public function getProducts()
	{
		return $this->hasMany('Products');
	}

	public function getFavs()
	{
		return $this->morphMany('Favourites', 'getFav');
	}

}