<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar_company');
			$table->string('name_en_company');
			$table->string('type_work');
			$table->integer('created_year');
			$table->string('num_employees');
			$table->string('place_company');
			$table->longText('descr_ar');
			$table->longText('descr_en');
			$table->integer('commerical_guarantee')->default('0');
			$table->integer('quality_sup');
			$table->integer('shipping_specific_date')->default('0');
			$table->integer('promotion_sup_id')->unsigned()->nullable();
			$table->string('job_title');
			$table->string('phone');
			$table->string('tel');
			$table->string('fax');
			$table->string('address');
			$table->string('postal_code');
			$table->integer('approve')->default('0');
			$table->integer('category_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('town_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}