<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->integer('status_id')->unsigned();
			$table->integer('coupon_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->timestamps();
			$table->integer('number_charge')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}