<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('id', 'first_name', 'last_name', 'phone', 'company_name', 'address_company', 'birth_date', 'type', 'email', 'password', 'image', 'is_notification', 'is_notify_chat');

	public function getStores()
	{
		return $this->hasOne('Suppliers');
	}

	public function getFav()
	{
		return $this->morphMany('Favourites', 'getFav');
	}

	public function getPaymentsDetails()
	{
		return $this->hasMany('PaymentDetails');
	}

	public function getCarts()
	{
		return $this->hasMany('Cart');
	}

}