<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255)->nullable();
			$table->string('last_name');
			$table->string('phone');
			$table->string('company_name')->nullable();
			$table->string('address_company')->nullable();
			$table->date('birth_date');
			$table->integer('type')->default('0');
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('image', 255)->nullable();
			$table->integer('is_notification')->default('1');
			$table->integer('is_notify_chat')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}