<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->char('id');
			$table->string('type', 255);
			$table->string('notifiable_type', 255);
			$table->bigInteger('notifiable_id');
			$table->text('data');
			$table->integer('msg_id')->primary();
			$table->integer('read')->default('0');
			$table->timestamp('read_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}