<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersAddressesTable extends Migration {

	public function up()
	{
		Schema::create('users_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fullname');
			$table->string('note');
			$table->integer('is_address');
			$table->string('phone', 255);
			$table->integer('postal_code');
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('town_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_addresses');
	}
}