<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function enrollments()
	{
		return $this->hasMany('Enrollment');
	}

	public function payments()
	{
		return $this->hasMany('Payment');
	}

}