<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvocesTable extends Migration {

	public function up()
	{
		Schema::create('invoces', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_id')->nullable();
			$table->double('total')->nullable();
			$table->bigInteger('currency_id')->nullable();
			$table->bigInteger('customer_id')->nullable();
			$table->date('ordered_date')->nullable();
			$table->string('address', 200)->nullable();
			$table->bigInteger('shipping_id')->nullable();
			$table->bigInteger('payment_id')->nullable();
			$table->string('offer_id')->nullable();
			$table->bigInteger('driver_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoces');
	}
}