<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRefundTable extends Migration {

	public function up()
	{
		Schema::create('refund', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('order_id')->nullable();
			$table->bigInteger('customer_id')->nullable();
			$table->double('amount')->nullable();
			$table->text('reason')->nullable();
			$table->string('transaction_num', 200)->nullable();
			$table->bigInteger('refund_status_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('refund');
	}
}