<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cost_center', function(Blueprint $table) {
			$table->foreign('headquarter_id')->references('id')->on('headquarter')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('venues', function(Blueprint $table) {
			$table->foreign('cost_center_id')->references('id')->on('cost_center')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('budget_plan', function(Blueprint $table) {
			$table->foreign('year_id')->references('id')->on('year')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('budget_plan', function(Blueprint $table) {
			$table->foreign('rubro_type_id')->references('id')->on('rubro_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('budget_plan', function(Blueprint $table) {
			$table->foreign('cost_center')->references('id')->on('cost_center')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('cost_center', function(Blueprint $table) {
			$table->dropForeign('cost_center_headquarter_id_foreign');
		});
		Schema::table('venues', function(Blueprint $table) {
			$table->dropForeign('venues_cost_center_id_foreign');
		});
		Schema::table('budget_plan', function(Blueprint $table) {
			$table->dropForeign('budget_plan_year_id_foreign');
		});
		Schema::table('budget_plan', function(Blueprint $table) {
			$table->dropForeign('budget_plan_rubro_type_id_foreign');
		});
		Schema::table('budget_plan', function(Blueprint $table) {
			$table->dropForeign('budget_plan_cost_center_foreign');
		});
	}
}