<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('application_experiences', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('application_educations', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_category_translation', function(Blueprint $table) {
			$table->foreign('job_category_id')->references('id')->on('job_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_domain_translations', function(Blueprint $table) {
			$table->foreign('job_domain_id')->references('id')->on('job_domains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('application_stages', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_region_id_foreign');
		});
		Schema::table('application_experiences', function(Blueprint $table) {
			$table->dropForeign('application_experiences_application_id_foreign');
		});
		Schema::table('application_educations', function(Blueprint $table) {
			$table->dropForeign('application_educations_application_id_foreign');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->dropForeign('job_region_id_foreign');
		});
		Schema::table('job_category_translation', function(Blueprint $table) {
			$table->dropForeign('job_category_translation_job_category_id_foreign');
		});
		Schema::table('job_domain_translations', function(Blueprint $table) {
			$table->dropForeign('job_domain_translations_job_domain_id_foreign');
		});
		Schema::table('application_stages', function(Blueprint $table) {
			$table->dropForeign('application_stages_application_id_foreign');
		});
	}
}