<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('application_experiences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('application_id')->unsigned();
			$table->date('date_from');
			$table->date('date_to');
			$table->string('job_title')->nullable();
			$table->string('company')->nullable();
			$table->text('short_description')->nullable();
			$table->text('tasks')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('application_experiences');
	}
}