<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobTable extends Migration {

	public function up()
	{
		Schema::create('job', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('photo_path')->nullable();
			$table->boolean('enabled');
			$table->integer('reference_number')->nullable();
			$table->tinyInteger('status')->unsigned()->nullable();
			$table->tinyInteger('type')->unsigned();
			$table->tinyInteger('timing')->unsigned()->nullable();
			$table->tinyInteger('contract_type')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->string('postal_code')->nullable();
			$table->string('city')->nullable();
			$table->string('video_url')->nullable();
			$table->tinyInteger('wanted_experience')->unsigned();
			$table->tinyInteger('wanted_education')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('job');
	}
}