<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactFoldersTable extends Migration {

	public function up()
	{
		Schema::create('contact_folders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('contact_folder_access_id')->unsigned();
			$table->string('name');
			$table->integer('order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contact_folders');
	}
}