<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactListItemsTable extends Migration {

	public function up()
	{
		Schema::create('contact_list_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->integer('contact_list_id')->unsigned();
			$table->integer('contact_id')->unsigned();
			$table->integer('order')->default('0');
			$table->integer('contact_phone_number_id')->unsigned()->nullable();
			$table->integer('incoming_number_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contact_list_items');
	}
}