<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShowroomsTable extends Migration {

	public function up()
	{
		Schema::create('showrooms', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('business_name', 255);
			$table->string('image', 255);
			$table->text('description');
			$table->time('open_hour');
			$table->time('close_hour');
			$table->string('location', 255)->nullable();
			$table->decimal('latitude', 12,10)->nullable();
			$table->decimal('longitude', 12,10);
			$table->bigInteger('city_id')->unsigned();
			$table->date('open_day');
			$table->timestamps();
			$table->date('close_day');
		});
	}

	public function down()
	{
		Schema::drop('showrooms');
	}
}