<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLayoutsTable extends Migration {

	public function up()
	{
		Schema::create('Layouts', function(Blueprint $table) {
			$table->increments('idLayout');
			$table->string('AppName')->nullable();
			$table->string('AppIconUrl')->nullable();
			$table->string('FormTitle')->nullable();
			$table->integer('FormWidth')->unsigned()->nullable();
			$table->integer('FormHeight')->unsigned()->nullable();
			$table->string('FormBackColor')->nullable();
			$table->string('BackgroundImageUrl')->nullable();
			$table->integer('ButtonWidth')->unsigned()->nullable();
			$table->integer('ButtonHeight')->unsigned()->nullable();
			$table->string('ButtonBackColor')->nullable();
			$table->string('ButtonForeColor')->nullable();
			$table->integer('ButtonFontSize')->unsigned()->nullable();
			$table->integer('ButtonLeft')->unsigned()->nullable();
			$table->integer('ButtonBottom')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Layouts');
	}
}