<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->integer('type');
			$table->integer('tone');
			$table->bigInteger('template_id')->unsigned();
			$table->longText('templatesettings');
			$table->integer('useimages');
			$table->integer('imagestype')->nullable();
			$table->integer('imagesaimodel')->nullable();
			$table->integer('imagescounttype')->nullable();
			$table->integer('imagesqty')->nullable();
			$table->longText('images');
			$table->string('author');
			$table->string('title');
			$table->string('topic');
			$table->longText('description')->nullable();
			$table->string('keywords')->nullable();
			$table->integer('language');
			$table->integer('bookaimodel');
			$table->integer('covertype');
			$table->string('coverurl');
			$table->longText('coverhtml');
			$table->string('covertitle');
			$table->integer('status');
			$table->text('errormessage')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}