<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('templates', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('font');
			$table->integer('fontsize');
			$table->text('context');
			$table->integer('chapterstyle');
			$table->integer('chapteralignment');
			$table->integer('sectionstyle');
			$table->integer('linespacing');
			$table->integer('paragrapthspacing');
			$table->integer('pagesize');
			$table->integer('numbering');
			$table->integer('textalign');
			$table->integer('margintop');
			$table->integer('marginbottom');
			$table->integer('marginleft');
			$table->string('marginright');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('templates');
	}
}