<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Orders extends Model 
{

    protected $table = 'Orders';
    public $timestamps = true;

    public function bookings()
    {
        return $this->belongsTo('App\Bookings', 'waterCustId');
    }

    public function customers()
    {
        return $this->belongsTo('App\WaterCustomer', 'id');
    }

    public function productOrders()
    {
        return $this->hasMany('App\Products', 'id');
    }

}