<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->bigInteger('waterSavingAmount')->unsigned();
			$table->bigInteger('moneySaved');
			$table->enum('availability', array('ACTIVE', 'SUSPENDED', 'DELETED'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}