<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Bookings extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;

    public function customer()
    {
        return $this->belongsTo('WaterCustomer', 'id');
    }

    public function installers()
    {
        return $this->hasMany('App\Installers', 'installerWorkPostId');
    }

    public function bookingProducts()
    {
        return $this->hasManyThrough('App\Products', 'App\Orders', 'id', 'productID', 'customerId');
    }

    public function bookingOrders()
    {
        return $this->hasMany('App\WaterCustomer', 'customerId');
    }

}