<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('user', 30);
			$table->string('password');
			$table->tinyInteger('status')->default('1');
			$table->string('uuid', 37);
			$table->integer('default_select_comp');
			$table->integer('chkpermiss')->default('1');
			$table->integer('sysadmin')->default('0');
			$table->integer('parent_id')->default('0');
			$table->string('modules');
			$table->string('created_by');
			$table->string('updated_by');
			$table->integer('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}