<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('module_id')->unsigned();
			$table->tinyInteger('isRead');
			$table->tinyInteger('isAdd');
			$table->tinyInteger('isDelete');
			$table->tinyInteger('isEdit');
			$table->tinyInteger('isPrint');
			$table->tinyInteger('isExport');
			$table->tinyInteger('isCancel');
			$table->tinyInteger('isApprove');
			$table->tinyInteger('isMauthor');
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}