<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function leadscreated()
    {
        return $this->hasMany('App\Client', 'user_created_id');
    }

    public function leadsmonitor()
    {
        return $this->hasMany('App\Lead', 'user_monitor_id');
    }

    public function leadsassigned()
    {
        return $this->hasMany('App\Client', 'user_assigned_id');
    }

    public function address()
    {
        return $this->hasMany('App\Addressbook', 'parent_id');
    }

}