<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsTable extends Migration {

	public function up()
	{
		Schema::create('leads', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('source', 16)->nullable();
			$table->string('status', 16)->nullable()->default('0');
			$table->bigInteger('client_id')->unsigned();
			$table->integer('user_created_id')->unsigned();
			$table->integer('user_assigned_id')->unsigned();
			$table->string('user_monitor_id', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('leads');
	}
}