<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStocksTable extends Migration {

	public function up()
	{
		Schema::create('stocks', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('references');
			$table->string('designations', 100);
			$table->integer('quantity');
			$table->enum('status', array('new', 'used'));
			$table->string('origin', 65);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stocks');
	}
}