<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmergencyReportTable extends Migration {

	public function up()
	{
		Schema::create('emergency_report', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('pernr', 10);
			$table->integer('org_id');
			$table->string('personnel_area', 10);
			$table->string('personnel_sub_area', 10);
			$table->string('description', 225)->nullable();
			$table->integer('file_id')->nullable();
			$table->string('pernr_receiver', 10);
			$table->integer('org_id_receiver');
			$table->string('personnel_area_receiver', 10);
			$table->string('personnel_sub_area_receiver', 10);
			$table->integer('created_by');
			$table->integer('updated_by')->nullable();
			$table->integer('type')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('emergency_report');
	}
}