<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmergencyReport extends Eloquent {

	protected $table = 'emergency_report';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('pernr', 'org_id', 'personnel_area', 'personnel_sub_area', 'description', 'file_id', 'pernr_receiver', 'org_id_receiver', 'personnel_area_receiver', 'personnel_sub_area_receiver', 'created_by', 'updated_by', 'type');

	public function files()
	{
		return $this->belongsTo('App\Model\FilesEmergency', 'file_id');
	}

}