<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('subscribe', 'rent', 'service'));
			$table->double('required_cost')->nullable();
			$table->string('paid_cost')->nullable();
			$table->integer('payment_method_id')->unsigned();
			$table->integer('estate_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}