<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('about_ajar_ar');
			$table->longText('about_ajar_en');
			$table->longText('vision_ar');
			$table->longText('vision_en');
			$table->longText('goals_ar');
			$table->longText('goals_en');
			$table->longText('why_use_ajar_ar');
			$table->longText('why_use_ajar_en');
			$table->longText('descr_ar');
			$table->longText('descr_en');
			$table->string('email');
			$table->string('phone');
			$table->longText('owner_text_ar');
			$table->longText('owner_text_en');
			$table->longText('manager_text_ar');
			$table->longText('manager_text_en');
			$table->longText('renter_text_ar');
			$table->longText('renter_text_en');
			$table->string('facebook');
			$table->string('twitter');
			$table->string('linkedin');
			$table->string('adv_1_title_ar');
			$table->string('adv_1_title_en');
			$table->longText('adv_1_text_ar');
			$table->longText('adv_1_text_en');
			$table->string('adv_2_tilte_ar');
			$table->string('adv_2_tilte_en');
			$table->longText('adv_2_text_ar');
			$table->longText('adv_2_text_en');
			$table->string('adv_3_tilte_ar');
			$table->string('adv_3_tilte_en');
			$table->longText('adv_3_text_ar');
			$table->longText('adv_3_text_en');
			$table->string('adv_4_title_ar');
			$table->string('adv_4_title_en');
			$table->longText('adv_4_text_ar');
			$table->longText('adv_4_text_en');
			$table->double('added_value_tax');
			$table->double('payment_gate_ratio');
			$table->double('rents_ratio');
			$table->double('services_ratio');
			$table->double('superadmin_ratio');
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}