<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesRequestsTable extends Migration {

	public function up()
	{
		Schema::create('services_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('estate_id')->unsigned();
			$table->integer('unit_id')->unsigned();
			$table->integer('renter_id')->unsigned();
			$table->integer('service_provider_id')->unsigned();
			$table->timestamps();
			$table->boolean('ticket_status')->nullable();
			$table->enum('type', array('service', 'complain'));
			$table->longText('complain_text')->nullable();
			$table->date('service_date')->nullable();
			$table->time('service_time')->nullable();
			$table->enum('periority', array('high', 'medium.low'));
			$table->string('image')->nullable();
			$table->string('address')->nullable();
			$table->double('lat')->nullable();
			$table->double('lng')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('services_requests');
	}
}