<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('user_id');
			$table->string('email', 100)->unique();
			$table->string('password', 255);
			$table->enum('type', array('admin', 'enterprise', 'freelancer'))->nullable();
			$table->string('notifications')->nullable();
			$table->string('messages')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}