<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('waters', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('periods', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_info', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('notification_settings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('walk_steps', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('moods', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('moods', function(Blueprint $table) {
			$table->foreign('mood_type_id')->references('id')->on('types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('logout_reasons', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('weights', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('waters', function(Blueprint $table) {
			$table->dropForeign('waters_user_id_foreign');
		});
		Schema::table('periods', function(Blueprint $table) {
			$table->dropForeign('periods_user_id_foreign');
		});
		Schema::table('user_info', function(Blueprint $table) {
			$table->dropForeign('user_info_user_id_foreign');
		});
		Schema::table('notification_settings', function(Blueprint $table) {
			$table->dropForeign('notification_settings_user_id_foreign');
		});
		Schema::table('walk_steps', function(Blueprint $table) {
			$table->dropForeign('walk_steps_user_id_foreign');
		});
		Schema::table('moods', function(Blueprint $table) {
			$table->dropForeign('moods_user_id_foreign');
		});
		Schema::table('moods', function(Blueprint $table) {
			$table->dropForeign('moods_mood_type_id_foreign');
		});
		Schema::table('logout_reasons', function(Blueprint $table) {
			$table->dropForeign('logout_reasons_user_id_foreign');
		});
		Schema::table('weights', function(Blueprint $table) {
			$table->dropForeign('weights_user_id_foreign');
		});
	}
}