<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWeightsTable extends Migration {

	public function up()
	{
		Schema::create('weights', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->enum('unit_type', array('metric', 'imperial'));
			$table->float('total');
		});
	}

	public function down()
	{
		Schema::drop('weights');
	}
}