<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->index();
			$table->string('email', 255)->index();
			$table->string('password', 255);
			$table->string('remember_token', 255);
			$table->string('user_photo', 255)->nullable();
			$table->datetime('birthday')->nullable();
			$table->tinyInteger('status');
			$table->enum('permission', array('master', 'admin', 'student'));
			$table->datetime('last_access_at')->nullable();
			$table->string('currency', 5);
			$table->string('phone', 20)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}