<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('Projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email');
			$table->datetime('email_verified_at')->nullable();
			$table->tinyInteger('status');
			$table->datetime('finished_at')->nullable();
			$table->string('name', 150);
			$table->string('authorization');
			$table->integer('client_id')->unsigned();
			$table->datetime('authorization_confirmed_at');
			$table->datetime('authorization_expire_at');
		});
	}

	public function down()
	{
		Schema::drop('Projects');
	}
}